#version 330
#extension GL_EXT_gpu_shader4 : enable
//Truchet HillsMod01.fsh  by   gls9102
//https://www.shadertoy.com/view/wslcz2
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// v1.0.1

#define PI 3.1415
#define ITERATIONS 25.

float ran21(vec2 uv) {
    return fract(cos(dot(cos(uv.x*uv.y)-32.2,tan(uv.x/uv.y)-23.5)*1322.24)*432122.62);
}
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    vec2 uv = (gl_FragCoord.xy-.5*iResolution.xy)/iResolution.x;
    vec2 uvb = uv;

    vec3 col = vec3(0);
    for(float i=1.;i<=ITERATIONS;i++) {
        float cur = i/ITERATIONS;
        uv = uvb;
        uv *= 10.0-cur*1.1;
        uv.y += iTime*0.6;
    
        vec2 gv = fract(uv)-.5;
        vec2 id = floor(uv);
    
        gv.x *= (ran21(id)>.5) ? -1. : 1.;
        vec2 ruv = gv-sign(gv.x+gv.y+.001)*.5;
        float tile = smoothstep(.01,-.01,abs(length(ruv)-.5)-.1);
        float rot = atan(ruv.x,ruv.y)/PI;
    
        float mul = mod(id.x+id.y,2.)==1. ? -1. : 1.;
        float h = smoothstep(cur-.1,cur,sin((rot*4.*mul+iTime)*PI)*.25+.75);
        
        col = max(col,h*tile*cur);
    }
    
    gl_FragColor = vec4(col,1.0);
}

